
   /*
   *  Object %name    : %
   *  State           :  %state%
   *  Creation date   :  18-Mar-08 
   *  Last modified   :  %modify_time%
   */
  /** @file
   *  \brief A brief description of this module
   *
   *  \version CERT_TLK_ATP_main.c#1:csrc:1
   *  \author Sagitb
   *  \remarks Copyright (C) 2008 by Discretix Technologies Ltd.
   *           All Rights reserved
   */


/***** Include Files **************/
#include "DX_VOS_BaseTypes.h"
#include "MW_ATP_defines.h"
#include "MW_ATP_define_flags.h"
#include "MW_ATP_UTIL_funcs.h"
#include "CERT_TLK_ATP_Defines.h"
#include "CERT_TLK_ATP_util.h"
/******** Defines ************/
extern DxError_t CERT_TLK_ATP_menu(void);

/*****************************************************************************
* Function Name:
*  main
*
* Inputs:
*  None
*
* Outputs:
*  None
*
* Description:
*  This function runs the ATP menu
*
******************************************************************************/
#if CERT_TLK_QA_ATP_TST
 int main(int argc, char *argv[])
#else 
 DxStatus CERT_TLK_ATP_main (int argc, char *argv[])
#endif  /* CERT_TLK_QA_ATP_TST */
 {
    /********* TST Variables Definitions ************/
    DxError_t           TST_Status = DX_SUCCESS;
    
    /* Handle Command Line Arguments */
    TST_Status = MW_ATP_UTIL_ParseArgs(argc,argv);
    TST_ATP_CHECK_ERROR_RETURN(TST_Status,
                                         "MW_ATP_UTIL_ParseArgs",
                                         "!!!!!!!!!",
                                         "!!!!!!!!!");
    

    /* Init CRYS */
    TST_Status = MW_ATP_UTIL_Init_CRYS();
    TST_ATP_CHECK_ERROR_RETURN(TST_Status,
                                         "MW_ATP_UTIL_Init_CRYS",
                                         "!!!!!!!!!",
                                         "!!!!!!!!!");
    

    
    /* Start TLK_CERT_ATP and its Menu */
    TST_Status = CERT_TLK_ATP_menu();

    return 0;

  EXIT_ON_ERROR:
  {
    return DX_FAILURE;
  }
 }



